Ta (berime) datoteka je bila ustvarjena 2026-01-28. Avtor datoteke: Simon Koblar

# SPLOŠNE INFORMACIJE

# Ime podatkovne zbirke
Dostopnost javnega potniškega prometa v letu 2024

# Licenca
CC BY-4.0

# Avtorji
**Vodilni avtor**  
Ime in priimek: Simon Koblar  
ORCID: 0000-0003-4470-4360  
Organizacija: Urbanistični inštitut Republike Slovenije  
Naslov: Trnovski pristan 2, 1000 Ljubljana, Slovenija  
Elektronska pošta: simonk@uirs.si

**Ostali avtorji**  
Ime in priimek: Matej Gabrovec
ORCID: 0000-0002-4018-3070  
Organizacija: Geografski inštitut Antona Melika, Znanstvenoraziskovalni center Slovenske akademije znanosti in umetnosti  
Naslov: Novi trg 2, 1000 Ljubljana, Slovenija  
Elektronska pošta:  matej.gabrovec@zrc-sazu.si

# Druge informacije
Obdobje zbiranja podatkov: od 2023-01-01 do 2024-11-10

Območje obravnave: Celotna Slovenija  

Izdajatelj: Urbanistični inštitut Republike Slovenije, Ljubljana, 2025  

Sofinancerji projekta:  
Javna agencija za znanstvenoraziskovalno in inovacijsko dejavnost RS – ARIS iz raziskovalnih in infrastrukturnih programov:

* I0-0016 Infrastrukturna dejavnost UI
* P5-0100 Prostorsko načrtovanje
* P6-0101 Geografija Slovenije

## Povzetek

Zbirka podatkov vsebuje prostorske podatke o dostopnosti do javnega potniškega prometa (JPP) v Sloveniji v jeseni 2024, ko so že veljale nove koncesije v medkrajevnem linijskem prometu. Osnovni podatki so izračunani na ravni poseljenih hišnih naslovov, podatki vezani na število prebivalcev pa so izračunani na prostorske enote (občine, statistične regije, kohezijski regiji in Slovenijo).

## Metodologija
Analize smo naredili s programsko opremo PostgreSQL z dodatkom PostGIS. Celoten postopek je pripravljen v obliki SQL in shell skript. Za izris kart smo uporabili program QGIS. Izvoz atributivnih podatkov je bil narejen s programskim paketom R.

#### Vhodni podatki
Podatke o voznih redih smo pridobili iz različnih virov:

* Nacionalni vozni red.
Cela Slovenija – javni linijski prevoz potnikov v notranjem cestnem prometu in javni železniški prevoz. Vir: Nacionalni center za upravljanje prometa – spletni servis (GTFS) (oktober 2024).
* Ljubljanski potniški promet – mestni promet. Mestne in nekatere primestne linije v Mestni občini Ljubljana z okolico. Vir: Ljubljanski potniški promet – spletni servis v formatu GTFS (oktober 2024).
* Arriva – mestni promet. Mestni linijski prevoz potnikov v mestih Ptuj, Piran, Novo mesto, Kranj, Koper in Jesenice. Vir: Arriva po e‑pošti v formatu GTFS za leto 2023, ročno vneseni popravki za leto 2024. Izdelava lastne GTFS datoteke za Jesenice in Ptuj.
* Nomago – mestni promet. Mestni linijski prevoz potnikov v mestih Velenje, Celje, Sevnica, Krško, Brežice, Postojna in Nova Gorica. Vir: Nomago – prejeto po e‑pošti v nestandardnem zapisu za leto 2023, pretvorba v GTFS format in podaljšanje režima na leto 2024 (Nomago, 2024).
* Marprom. Mestni linijski prevoz potnikov v Mariboru. Vir: Marprom – prejeto po e‑pošti v formatu GTFS za leto 2023, podaljšan režim na leto 2024 (Marprom, 2024).
* Mestni promet Murska Sobota. Vir: GTFS izdelan iz voznega reda objavljenega na spletni strani prevoznika AP Murska Sobota, 2024.

Podatke o številu prebivalcev po hišnih naslovih smo pridobili iz centralnega registra prebivalcev (stanje na 9. 8. 2024). Ker ima ista oseba lahko prijavljeno tako stalno kot začasno prebivališče, smo v izogib dvojnemu štetju upoštevali lokacijo začasnega prebivališča in s tem skladno z metodologijo statističnega urada Republike Slovenije (Razpotnik, 2024) določili t.i. običajno prebivališče. Po določitvi običajnega prebivališča smo sešteli skupno število prebivalcev po hišnih naslovih.

#### Režimi in kriteriji dostopnosti

V analizi smo se osredotočili na tri režime (delavnik v času šolskega pouka, sobota ter nedelje in prazniki), določene v uredbi (Uredba o načinu izvajanja ..., 2024). Po uredbi je veljaven tudi režim delavnik v času šolskih počitnic, vendar nam za ta režim ni uspelo zbrati vseh voznih redov, zato ga nismo vključili v analizo. Za leto 2024 smo izbrali novembrske termine, saj so se v prvih mesecih po uvedbi vozni redi še dopolnjevali. Z izbiro kasnejšega datuma smo zagotovili vključitev vseh večjih popravkov voznih redov. Razrede dostopnosti smo določili v skladu z izvorno metodologijo, ki za različne dneve opredeljuje različne kriterije (Gabrovec in Bole, 2006).


Preglednica: datumi, za katere smo izvedli analize dostopnosti, in kriteriji za uvrstitev v razred dostopnosti.

| Dan v tednu                    | Oznaka | Izbrani datumi | Kriterij za razrede dostopnosti (število parov voženj)|
|--------------------------------|--------|----------------|-------------------------------------------------------|
| Delavnik v času šolskega pouka | DŠ     | 13. 11. 2024   | nezadovoljiva (1–7)                                   |
|                                |        |                | zadovoljiva (8–22)                                    |
|                                |        |                | primerna (23 ali več)                                 |
|--------------------------------|--------|----------------|-------------------------------------------------------|
| Sobota                         | SO     | 16. 11. 2024   | nezadovoljiva (1–3)                                   |
| Nedelja in prazniki            | NEP    | 17. 11. 2024   | zadovoljiva (4–7)                                     |
|                                |        |                | primerna (8 ali več)                                  |

#### Izračun dostopnosti do JPP
Za izbrane režime smo najprej iz vseh voznih redov zbrali podatke o vseh dnevnih odhodih po postajališčih. Poleg podatka o postajališču (stop_id) smo imeli tudi podatek o liniji (route_id) in vožnji (trip_id). Nato smo prostorsko združili sloj hišnih naslovov s slojem odhodov po postajališčih do vključno 1000 m zračne razdalje. V naslednjem koraku smo po hišnih naslovih prešteli število voženj ločeno za 500 in 1000 m oddaljenost postajališč in sicer ločeno za vsak izbran režim. Pri seštevanju vrednosti smo posamezno vožnjo upoštevali le enkrat (funkcija count unique), tudi če je vožnja na voljo na več kot enemu postajališču v ustrezni razdalji od hišnega naslova.

V zadnjem koraku smo podatke po hišnih naslovih združili s številom prebivalcev ter neposredno iz podatkov po hišnih naslovih agregirali na večje prostorske enote (občine, statistične regije, kohezijski regiji in Slovenija). V kolikor je v bilo v posamezni kategoriji med 1 in 10 prebivalcev, smo dejansko vrednost zamenjali z 10. S tem smo zagotovili ustrezno anonimizacijo števila prebivalcev. Izračunane deleže smo zaradi anonimizacije zaokrožili na eno decimalko natančno.

# Digitalni podatki
V prilogi so podatki v različnih formatih. Vsebine csv in xlsx datotek so identične, geopackage datoteka pa vsebuje tudi prostorske podatke:

* Geopackage format (dostopnost_jpp_2024.gpkg) vključujejo prostorske podatke za pregled v priloženi QGIS datoteki (dostopnost_jpp_2024.qgz) - pripravljena z različico QGIS 3.44
* Atributivni podatki v csv in xlsx formatu - podatki po prostorskih enotah brez geometrije
* Metapodaki - opis podatkovnih slojev in stolpcev znotraj slojev v csv in xlsx formatu

CSV podatki za ločilo uporabljajo vejico, decimalke so ločene s pikami, besedilni stolpci so oviti v dvojne narekovaje, Kodna tabela: UTF8-BOM

## Seznam datotek:
* berime.md  
* prostorski_podatki\dostopnost_jpp_2024.gpkg     
* prostorski_podatki\dostopnost_jpp_2024.qgz  
* atributivni_podatki\excel\jpp_frekvence_2024_prostorske_enote.xlsx  
* atributivni_podatki\csv\jpp_frekvence_kohezijske_regije_2024.csv  
* atributivni_podatki\csv\jpp_frekvence_obcine_2024.csv  
* atributivni_podatki\csv\jpp_frekvence_slovenija_2024.csv  
* atributivni_podatki\csv\jpp_frekvence_statisticne_regije_2024.csv  
* metapodatki\excel\metapodatki.xlsx  
* metapodatki\csv\seznam_slojev.csv  
* metapodatki\csv\seznam_stolpcev.csv  
