#script to calculate correlations
library(tidyverse)
library(dendroTools)

initial_data <- read.table('initial_data.txt', sep = '\t', header = T)
clim <- read.table('monthly_clim_data.txt', sep = '\t', header = T )

#climatic factors 
par.clim <- c('tmed', 'vpd', 'cwbm')
#seasons cgs = current growing seasons; win = dormancy period; pgs = previous growing season
seasons <- c('cgs', 'win', 'pgs')
#study sites
lst.cod <- unique(initial_data$ID)
#study periods 
period <- c('early', 'late', 'all')

cor.f <- data.frame()
i=1
for (i in 1:length(lst.cod)) {
 
  chron.tmp1 <- filter(initial_data, ID == lst.cod[i])
  chron.tmp1 <- as.data.frame(chron.tmp1)
  rownames(chron.tmp1)<- as.numeric(chron.tmp1$year)
  chron.tmp1 <- select(chron.tmp1, res)
  chron.tmp1 <- na.omit(chron.tmp1)
  clim.tmp1 <- filter(clim, ID == lst.cod[i])
  cor.plot <- data.frame()
  
  for (j in 1:length(par.clim)) {
    
    clim.tmp2 <- select(clim.tmp1, Year = year, Month = month, par.clim[j])
    
    for (k in 1:length(seasons)) {
      
      if (seasons[k] == 'pgs') {
        
        month.start <- -6
        month.finish <- -10
        m.no <- 24
        
      } else if (seasons[k] == 'win') {
       
         month.start <- -11
         month.finish <- 3
         m.no <- 24
         
      } else {
        
        month.start <- 4
        month.finish <- 9
        m.no <- 12
        
      }
      
      for (l in 1:length(period)) {
        
        if (period[l] == 'early'){
          
          chron.tmp2 <- filter(chron.tmp1, rownames(chron.tmp1) < 1986)
          
        } else if(period[l] == 'late'){
          
          chron.tmp2 <- filter(chron.tmp1, rownames(chron.tmp1) > 1985)
          
        } else {
          
          chron.tmp2 <- filter(chron.tmp1, rownames(chron.tmp1) > 1949)
        }
       
        #all correlations
        mresp <- monthly_response(chron.tmp2, clim.tmp2,
                                      method = "cor",
                                      cor_method = "pearson",
                                      remove_insignificant = F,
                                      row_names_subset = T,
                                      previous_year = T,
                                      reference_window = "end",
                                      boot = T,
                                      boot_n = 1000,
                                      lower_limit = 1,
                                      upper_limit = 6,
                                      tidy_env_data = T,
                                      month_interval = c(month.start, month.finish))
        
        tmp <- as.data.frame(mresp$calculations)
        tmp$length <- rownames(tmp)
        tmp <- pivot_longer(tmp,cols = 1:m.no, names_to = "month", values_to = "cor")
        tmp$seasons <- seasons[k] 
        tmp$par.clim <- par.clim[j]
        tmp$ID <- lst.cod[i]
        tmp$period <- period[l]
        
        no_obs <- mresp$analysed_period
        year.1 <- as.numeric(substr(no_obs, 8, 11))
        year.2 <- as.numeric(substr(no_obs, 1, 4))
        no_obs <- year.1 - year.2
        tmp$no_obs <- no_obs
        
        if (m.no ==12){
          
          tmp$month <- as.numeric(tmp$month)
          tmp$month <- tmp$month +12
          
        }
        
        
        #significant correlations
        mresp <- monthly_response(chron.tmp2, clim.tmp2,
                                  method = "cor",
                                  cor_method = "pearson",
                                  remove_insignificant = T,
                                  row_names_subset = T,
                                  previous_year = T,
                                  reference_window = "end",
                                  boot = T,
                                  boot_n = 1000,
                                  lower_limit = 1,
                                  upper_limit = 6,
                                  tidy_env_data = T,
                                  month_interval = c(month.start, month.finish))
        
        tmp.s <- as.data.frame(mresp$calculations)
        tmp.s$length <- rownames(tmp.s)
        tmp.s <- pivot_longer(tmp.s, cols = 1:m.no, names_to = "month", values_to = "cor.s")
        tmp.s$seasons <- seasons[k] 
        tmp.s$par.clim <- par.clim[j]
        tmp.s$ID <- lst.cod[i]
        tmp.s$period <- period[l]
        
        no_obs <- mresp$analysed_period
        year.1 <- as.numeric(substr(no_obs, 8, 11))
        year.2 <- as.numeric(substr(no_obs, 1, 4))
        no_obs <- year.1 - year.2
        tmp.s$no_obs <- no_obs
        
        if (m.no ==12){
          
          tmp.s$month <- as.numeric(tmp.s$month)
          tmp.s$month <- tmp.s$month +12
          
        }
        
        tmp <- left_join(tmp, tmp.s)
        tmp$significance <- ifelse(is.na(tmp$cor.s), 0, 1)
        tmp <- select(tmp, -cor.s)
        
        print(i)
        
        cor.plot <- rbind(cor.plot, tmp)
        cor.f <- rbind(cor.f, tmp)
        
         
      }
      
    }
    
  }
  
}



#merge the cor matrix with additional data at plot level

df_metadata <- select(initial_data, -year, -RW, -res, -samp.depth) %>% distinct()

cor.final <- left_join(cor.f, df_metadata)

age <- group_by(initial_data, ID)
age <- summarise(age, age = max(year) - min(year))
cor.final <- left_join(cor.final, age)

write.table(cor.final, 'correlations_matrix_input_model.txt', sep = '\t', row.names = F )
