#OAKS analyses using LMM
library(lmerTest)
library(MuMIn)
library(emmeans)
library(multcomp)
library(tidyverse)
library(performance)
library(sjPlot)

#data
oaks<-read.table('correlations_matrix_input_model.txt',header = T)

oaks<-oaks%>%filter(!is.na(cor))#remove NA values in r

oaks$climatechange<-plyr::mapvalues(oaks$shifts_SSP370_2061_2080_layer, unique(oaks$shifts_SSP370_2061_2080_layer), c('contraction','persistence'))

###new approach LMM-------
# full model --------------------------------------------------------------
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all')

check_distribution(oaks.el$cor)

lmm1el_all<-lmer(cor~bio18+bio9+bio10+bio11+par.clim*climatechange+period*climatechange+age+(1|ID)+(1|seasons), data=oaks.el, na.action = na.fail)

#model output table
tab_model(lmm1el_all , digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T, file = "tab_all.doc")

#model check
check_model(lmm1el_all, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#extract marginal means to obtain predicted mean values for levels
lmm1el.df<-cld(emmeans(lmm1el_all, ~par.clim*period*climatechange))%>%as.data.frame()
write.table(lmm1el.df, 'mem_all.txt', sep= '\t', row.names = F)

#save model
save(lmm1el_all, file = "model_full.Rda")

#for each climatic parameter ----------------------------------


#VPD
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & par.clim == 'vpd')

check_distribution(oaks.el$cor)

lmm1el_vpd<-lmer(cor~bio18+bio11+bio9+bio10+period*climatechange+age+(1|ID), data=oaks.el, na.action = na.fail)

#model check
check_model(lmm1el_vpd, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#model output table
tab_model(lmm1el_vpd, digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T,  file = "tab_vpd.doc")

#extract marginal means to obtain predicted mean values for levels
lmm1el.df<-cld(emmeans(lmm1el_vpd, ~period))%>%as.data.frame()

write.table(lmm1el.df, 'mem_e_l_sign_in_all_vpd.txt', sep= '\t', row.names = F)

#save model
save(lmm1el_vpd, file = "model_VPD.Rda")


#tmed
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & par.clim == 'tmed')

check_distribution(oaks.el$cor)

lmm1el_tmed<-lmer(cor~bio18+bio9+bio10+bio11+period*climatechange+age+(1|ID), data=oaks.el, na.action = na.fail)

#model check
check_model(lmm1el_tmed, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#model output table
tab_model(lmm1el_tmed, digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T, file = "tab_tmed.doc")


#extract marginal means to obtain predicted mean values for levels
lmm1el.df<-cld(emmeans(lmm1el_tmed, ~period))%>%as.data.frame()
write.table(lmm1el.df, 'mem_tmed.txt', sep= '\t', row.names = F)

#save model
save(lmm1el_tmed, file = "model_tmed.Rda")

#cwb
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & par.clim == 'cwbm')

check_distribution(oaks.el$cor)

lmm1el_cwb<-lmer(cor~bio18+bio9+bio10+bio11+period*climatechange+age+(1|ID), data=oaks.el, na.action = na.fail)

#model check
check_model(lmm1el_cwb, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#model output table
tab_model(lmm1el_cwb, digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T,  file = "tab_cwb.doc")

#extract marginal means to obtain predicted mean values for levels
lmm1el.df<-cld(emmeans(lmm1el_cwb, ~period*climatechange))%>%as.data.frame()
write.table(lmm1el.df, 'mem_cwb.txt', sep= '\t', row.names = F)

#save model
save(lmm1el_cwb, file = "model_CWB.Rda")


# Sensitivity analysis - only significant cor ----------------------------------------------------


#VPD
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & par.clim == 'vpd' & significance ==1)

check_distribution(oaks.el$cor)


lmm2el_vpd<-lmer(cor~bio18+bio11+bio9+bio10+period*climatechange+age+(1|ID), data=oaks.el, na.action = na.fail)

#model check
check_model(lmm2el_vpd, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#model output table
tab_model(lmm2el_vpd, digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T,  file = "tab_vpd-s.doc")

#tmed
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & par.clim == 'tmed' & significance ==1)

check_distribution(oaks.el$cor)

lmm2el_tmed<-lmer(cor~bio18+bio9+bio10+bio11+period*climatechange+age+(1|ID), data=oaks.el, na.action = na.fail)

#model check
check_model(lmm2el_tmed, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#model output table
tab_model(lmm2el_tmed, digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T, file = "tab_tmed-s.doc")


#cwb
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & par.clim == 'cwbm' & significance ==1)

check_distribution(oaks.el$cor)

lmm2el_cwb<-lmer(cor~bio18+bio9+bio10+bio11+period*climatechange+age+(1|ID), data=filter(oaks.el, cor>0), na.action = na.fail)

#model check
check_model(lmm2el_cwb, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

#model output table
tab_model(lmm2el_cwb, digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T,  file = "tab_cwb-s.doc")


#model all parametres
oaks.el <- oaks

oaks.el<-oaks.el%>%filter(period!='all' & significance==1)

check_distribution(oaks.el$cor)

lmm2el_all<-lmer(cor~bio18+bio9+bio10+bio11+par.clim*climatechange+period*climatechange+age+(1|ID)+(1|seasons), data=oaks.el, na.action = na.fail)

#model output table
tab_model(lmm2el_all , digits = 3, show.stat = T, digits.re = 3, digits.rsq = 3, show.re.var = T, file = "tab_all_m4-s.doc")

#model check
check_model(lmm2el_all, check = c( "vif", "qq", "normality", "linearity", "homogeneity",  "reqq", "pp_check",  "overdispersion"))

