#!/usr/bin/env python
"""
First test run of 
pelagia_trans model
====================
"""
import sys
from datetime import datetime, timedelta
from opendrift.readers import reader_netCDF_CF_generic
from opendrift.readers import reader_global_landmask
from opendrift.models.pelagia_IBM import Pelagia_IBM


startyear = sys.argv[1]
numyears = '4'  # just for names of output files

print(startyear)
Startyr = int(startyear)


odm = Pelagia_IBM(loglevel=20) # Initialize model and set log level (0 for debug)


# read MFS files - default reader
reader_MFS1 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/cur_rean_daily/'+startyear+'*.nc')
reader_MFS2 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/cur_rean_daily/'+str(Startyr+1)+'*.nc')
reader_MFS3 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/cur_rean_daily/'+str(Startyr+2)+'*.nc')
reader_MFS4 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/cur_rean_daily/'+str(Startyr+3)+'*.nc')
reader_MedBFM1 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS-BFM/monthly/'+startyear+'/*BIOL*.nc')
reader_MedBFM2 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS-BFM/monthly/'+str(Startyr+1)+'/*BIOL*.nc')
reader_MedBFM3 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS-BFM/monthly/'+str(Startyr+2)+'/*BIOL*.nc')
reader_MedBFM4 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS-BFM/monthly/'+str(Startyr+3)+'/*BIOL*.nc')
reader_MFS_bath = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/statics/MED-MFC_006_004_mask_bathy_copy3.nc')
#
odm.add_reader([reader_MFS1, reader_MFS2, reader_MFS3, reader_MFS4])
odm.add_reader([reader_MedBFM1, reader_MedBFM2, reader_MedBFM3, reader_MedBFM4], variables=['net_primary_production_of_biomass_expressed_as_carbon_per_unit_volume_in_sea_water'])
odm.add_reader(reader_MFS_bath, variables=['sea_floor_depth_below_sea_level'])
odm.add_reader(reader_MFS_bath, variables=['land_binary_mask'])
odm.add_reader(reader_MFS_bath, variables=['nearshore_mask'])


# odm.set_config('general:use_auto_landmask', True) # use default GSHHG vector landmask
odm.set_config('general:use_auto_landmask', False) # use model landmask

# Seed particles within predefined polygon
odm.seed_from_shapefile('convertedByApolloMapping/3d7053bc-f72d-11ee-bfa3-6b8e5cabd000.shp', z=-2, radius=0, number=10000,time=datetime(Startyr,1,1,0,0,0))


# Set beaching behaviour
odm.set_config('general:coastline_action', 'previous')
odm.set_config('drift:vertical_mixing', False)  # speed up the simulation

# Running the model (until end of driver data)
odm.run(time_step=timedelta(hours=1), time_step_output=timedelta(days=1), end_time=datetime(Startyr+3,12,31,23,59,0), outfile='Pelagia_baserun_'+numyears+'y_10k_'+startyear+'.nc')

# Print and plot results
print(odm)
odm.plot(filename='Pelagia_baserun_'+numyears+'y_10k_'+startyear+'.png',linecolor='biomass',lvmin=100,lvmax=20000)
odm.plot(filename='Pelagia_baserun_'+numyears+'y_10k_'+startyear+'.png')
# odm.plot(linecolor='number')
# odm.animation(fps=30,skip=1,color='number')
# odm.animation(background=['x_sea_water_velocity','y_sea_water_velocity'], skip=5)
# odm.animation(filename='Pelagia_WMed_forward_'+startyear+'-'+year2+'.gif',color='number')

