#!/usr/bin/env python
"""
First test run of 
pelagia_trans model
====================
"""
import sys
from datetime import datetime, timedelta
from opendrift.readers import reader_netCDF_CF_generic
# from opendrift.readers import reader_global_landmask
from opendrift.models.pelagia_IBM import Pelagia_IBM


startyear = sys.argv[1]
k1 = float(sys.argv[2])
k2 = float(sys.argv[3])
k3 = float(sys.argv[4])


print('Year = '+startyear)
print('k1 = '+str(k1))
print('k2 = '+str(k2))
print('k3 = '+str(k3))


odm = Pelagia_IBM(loglevel=20) # Initialize model and set log level (0 for debug)

# read MFS files
reader_MFS1 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/cur_rean_daily/'+startyear+'*.nc')
reader_MedBFM1 = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS-BFM/monthly/'+startyear+'/*BIOL*.nc')
reader_MFS_bath = reader_netCDF_CF_generic.Reader('/media/martin/MP4T_2/data/MFS/statics/MED-MFC_006_004_mask_bathy_copy3.nc')
#

odm.add_reader([reader_MFS1])
odm.add_reader([reader_MedBFM1], variables=['net_primary_production_of_biomass_expressed_as_carbon_per_unit_volume_in_sea_water'])
odm.add_reader(reader_MFS_bath, variables=['sea_floor_depth_below_sea_level'])
odm.add_reader(reader_MFS_bath, variables=['land_binary_mask'])
odm.add_reader(reader_MFS_bath, variables=['nearshore_mask'])


# odm.set_config('general:use_auto_landmask', True) # use default GSHHG vector landmask
odm.set_config('general:use_auto_landmask', False) # use model landmask

# Seed particles within predefined polygon
odm.seed_from_shapefile('convertedByApolloMapping/3d7053bc-f72d-11ee-bfa3-6b8e5cabd000.shp', z=-2, radius=0, number=2000,time=datetime(int(startyear),1,1,0,0,0))


# Set beaching behaviour
odm.set_config('general:coastline_action', 'previous')
odm.set_config('drift:vertical_mixing', False)  # speed up the simulation

# Set growth-mortality coefficients
odm.set_config('k1', k1)
odm.set_config('k2', k2)
odm.set_config('k3', k3)


# Running model (until end of driver data)
odm.run(time_step=timedelta(hours=1), time_step_output=timedelta(days=1), end_time=datetime(int(startyear)+1,1,1,0,0,0), outfile='Pelagia_Med_fwd_'+startyear+'.nc')


# Print and plot results
print(odm)
# odm.plot(linecolor='biomass',lvmin=100,lvmax=2000)
# odm.plot(filename='Pelagia_Med_fwd_'+startyear+'.png',linecolor='biomass',lvmin=100,lvmax=20000)
# odm.plot(filename='Pelagia_Med_fwd_BW_'+startyear+'.png')
# odm.plot(linecolor='number')
# odm.plot(filename='Pelagia_WMed_forward_'+startyear+'-'+year2+'.png')
# odm.animation(fps=30,skip=1,color='number')
# #odm.animation(background=['x_sea_water_velocity','y_sea_water_velocity'], skip=5)
# odm.animation(filename='Pelagia_WMed_forward_'+startyear+'-'+year2+'.gif',color='number')
#odm.plot()
