#!/bin/bash
# Script performs several multi-year runs with different growth-mortality coefficients
#C=("C2k7_1-6" "C2k7_2-6" "C2k7_3-6" )
#k1=(0.041 0.029 0.087 )
#k2=(1.85 5.25 5 )
#k3=(0.028 0.014 0.05 )

#C=("C2k7b_3-3" )
#k1=(0.037 )
#k2=(4.25 )
#k3=(0.02 )

C=("C2k8_1-1" )
k1=(0.059 )
k2=(3.7 )
k3=(0.036 )


# For each set of coefficients
for n in ${!C[@]};
do
    mkdir ${C[$n]}
    # Multi-year run
    # First year - needs initial seeding of particles#
#    ./Run_pelagia.py 2000 ${k1[$n]} ${k2[$n]} ${k3[$n]}   
    # Following years
    for i in $(seq 2013 2019)
    do 
      ./Restart_pelagia.py Pelagia_Med_fwd_$i.nc $((i+1)) ${k1[$n]} ${k2[$n]} ${k3[$n]} 
    done
    # Move all results to the new folder
    mv *.nc ${C[$n]}/
done 


