# Low but significant evolutionary potential for growth, phenology and reproduction traits in European beech

[https://doi.org/10.5061/dryad.x0k6djhrn](https://doi.org/10.5061/dryad.x0k6djhrn)

Phenotypic and genotypic data used in the paper Low but significant evolutionary potential for growth, phenology and reproduction traits in European beech.

<br>
## Description of the data and file structure

Data is provided in two separate files, phenotypic and genotypic data.

Phenotypic data consists of 16 traits recorded for 251 adult Fagus sylvatica trees growing in a single location. The data file contains 17 columns:

1. ID: sample identification number (same as sample in the genotype data file for adult trees, can be connected to a single tree coordinate through the genotype data file)
2. DBH-2018: Diameter at 1.30 m (cm) measured in 2018
3. GL-2018: Length of the growing season (days) in 2018
4. GL-2019: Length of the growing season (days) in 2019
5. LBB-2018: Length of budburst (GDD5, i.e. temperature sum of Growing Degree Days with base temperature of 5ºC) between budburst stage 2 and stage 5 in 2018
6. LBB-2019: Length of budburst (GDD5, i.e. temperature sum of Growing Degree Days with base temperature of 5ºC) between budburst stage 2 and stage 5 in 2019
7. BB-JD100-2018: Bud phenological stage at Julian day 100 (1-5 scale) in 2018
8. BB-JD100-2019: Bud phenological stage at Julian day 100 (1-5 scale) in 2019
9. SPSS-2018: Spring phenology score sum, i.e. sum of daily phenology scores during the observation period in 2018
10. SPSS-2018: Spring phenology score sum, i.e. sum of daily phenology scores during the observation period in 2019
11. FLW-2018: Male flowering stage at Julian day 114 (1-3 scale) in 2018
12. FT-JD108-2018: Fruit abundance at Julian day 108 (1-4 scale) in 2018
13. FT-JD217-2018: Fruit abundance at Julian day 217 (1-4 scale) in 2018
14. LLS-2018: Length of leaf senescence (days) in 2018
15. LLS-2019: Length of leaf senescence (days) in 2019
16. LS-JD287-2018: Leaf senescence stage at Julian day 287 (1-4 scale) in 2018
17. LS-JD267-2019: Leaf senescence stage at Julian day 267 (1-4 scale) in 2019

For LLS, NA means that the individual did not reach the final stage of senescence at the time of the last observation.

Genotypic data (16 nSSR loci) is provided for 251 adult Fagus sylvatica trees, 436 seeds collected from 22 adult trees and 400 saplings from two different regeneration events, all growing on the same plot. For each individual, coordinates (carthesian coordinates) and elevation are provided. Saplings/seedlings were collected at 4 locations in two different years, therefore, 50 saplings/seedlings share the same geographic coordinate.

Genotypic data file contains 35 columns:

1. Sample: sample identification number (same as ID in the genotype data file for adult trees)
2. Phase: ontogenetic stage, either tree (sampled in 2016), sapling (sampled in 2016, multiyear cohort aged five to nine years), seedling (sampled in 2019, one-year-old seedlings) or seed (sampled in 2016)
    3.-32.	Allele lengths for 16 SSR loci named as in Lefevre et al. 2012, 2 columns per locus (bp)
3. X: latitude in carthesian coordinates (m)
4. Y: longitude in carthesian coordinates (m)
5. Base elevation: Elevation of a tree above the sea level (m)

Missing SSR data in the genotype file is given as zero. NA means not applicable, i.e. not used in the study.

References: Lefevre, S., Wagner, S., Petit, R. J. &amp; De Lafontaine, G. (2012). Multiplexed microsatellite markers for genetic studies of beech. Mol. Ecol. Resour., 12, 484-491, 10.1111/j.1755-0998.2011.03094.x