Ta (berime) datoteka je bila ustvarjena 2025-03-26. Avtorji datoteke: Simon Koblar, Vita Žlender in Rok Brišnik

-------------------
SPLOŠNE INFORMACIJE
-------------------

## Ime podatkovne zbirke 

Zbirka podatkov o zelenih površinah za telesno dejavnost in preskrbljenosti z njimi v občinah Celje in Miklavž na Dravskem polju

## Avtorji

**Vodilni avtor**  

Ime in priimek: Vita Žlender  
ORCID: 0000-0002-3242-8015  
Organizacija: Urbanistični inštitut Republike Slovenije  
Naslov: Trnovski pristan 2, 1000 Ljubljana, Slovenija   
Elektronska pošta: vitaz@uirs.si  

**Ostali avtorji**  

Ime in priimek: Ina Šuklje Erjavec  
ORCID: 0000-0002-9319-8380  
Organizacija: Urbanistični inštitut Republike Slovenije  
Naslov: Trnovski pristan 2, 1000 Ljubljana, Slovenija  
Elektronska pošta: inas@uirs.si  

Ime in priimek: Jana Kozamernik  
ORCID: 0000-0002-6013-4815  
Organizacija: Urbanistični inštitut Republike Slovenije  
Naslov: Trnovski pristan 2, 1000 Ljubljana, Slovenija  
Elektronska pošta: janak@uirs.si  

Ime in priimek: Simon Koblar  
ORCID: 0000-0003-4470-4360  
Organizacija: Urbanistični inštitut Republike Slovenije  
Naslov: Trnovski pristan 2, 1000 Ljubljana, Slovenija  
Elektronska pošta: simonk@uirs.si  

Ime in priimek: Rok Brišnik  
ORCID: 0009-0007-4566-3894  
Organizacija: Urbanistični inštitut Republike Slovenije  
Naslov: Trnovski pristan 2, 1000 Ljubljana, Slovenija  
Elektronska pošta: rokbr@uirs.si  


Obdobje zbiranja podatkov: od 2022-10-01 do 2024-09-01

Območje obravnave:  
Mestna občina Celje, občina Miklavž na Dravskem Polju, Slovenija  

Sofinancerji projekta:  
Javna agencija za znanstvenoraziskovalno in inovacijsko dejavnost RS – ARIS, številka projekta: V5-2232    
Ministrstvo za naravne vire in prostor – MNVP  
Ministrstvo za zdravje – MZ


## Povzetek
Zbirka podatkov vsebuje prostorske podatke o zelenih površinah za telesno dejavnost v občinah Celje in Miklavž na Dravskem polju. Podatkovna zbirka vsebuje vektorske podatke o zelenih površinah za zgoščene in daljinske oblike telesne dejavnosti, podatke z dodatnimi imformacijami o opremljenosti zelenih površin in podatke o oddaljenosti hišnih naslovov do zelenih površin za telesno dejavnost, vključno s številom prebivalcev na hišnih naslovih. Podatki so bili zbrani v sklopu pilotnih aktivnosti v CRP projektu Priprava kazalnikov za oceno preskrbljenosti naselij z zelenimi površinami za telesno dejavnost v odprtem prostoru.

## Metodologija
Kazalnik PREZENCA je kombinirani kazalnik preskrbljenosti z ZP za TD, ki služi kot orodje občin za izboljšanje prostorskih pogojev za telesno dejavnost. Kazalnik smo zasnovali ločeno za prostorsko zgoščene in daljinske oblike telesne dejavnosti. Vključuje merila, obvezne in dodatne atribute, ki določajo minimalne pogoje za upoštevanje zelenih površin, ter dodatne za razvrščanje v kakovostne kategorije. Kriterialni sistem za vrednotenje atributov in razvrščanje v kategorije kakovosti je zasnovan tako, da omogoča prilagodljivost glede na razpoložljivost podatkov za obdelovano območje.  

**1.	Kazalnik PREZENCA za zelene površine za prostorsko zgoščene oblike telesne dejavnosti**  
Za prostorsko zgoščene oblike telesne dejavnosti so ključni trije obvezni atributi: območje ima prostorske značilnosti zelene površine; minimalna velikost je 250 m² in širina 5 m ter javna dostopnost. Pomembna sta še povezanost, zveznost in razmestitev ter namenskost. Priporočljivo je vključiti tudi ambientalno privlačnost in varnost.  

Slika 1: Vidiki za določitev in vrednotenje kakovosti ZP za prostorsko zgoščene oblike telesne dejavnosti.
![postopek določitve zelenih površin za telesno dejavnost](slika1.png)

***Določitev ZP za zgoščene oblike TD***  
Slika 2: Metodologija določitve območij ZP za zgoščene oblike TD z navedenimi vsemi uporabljenimi podatki.
 ![postopek določitve zelenih površin za telesno dejavnost](image.png)

***Dostopnost do ZP za zgoščene oblike TD***  
Oddaljenost je bila računana med hišnimi naslovi na testnem območju in vstopnimi točkami vseh ZP za zgoščene oblike TD po omrežju pešpoti, ki je bilo prevzeto iz baze OpenStreetMap (2024). Rezultat je seznam hišnih številk z navedbo ustreznih ZP za zgoščene oblike TD, do katerih je dostop mogoč ter časovna (v minutah) in dolžinska (v metrih) komponenta dostopa.

***Vrednotenje ZP za zgoščene oblike TD***  
Vrednotenje se je izvajalo na podlagi namenskosti. Namenskost se kot atribut ZP za potrebe kazalnika PREZENCA opredeljuje v smislu, ali je ZP večnamenskega ali enonamenskega značaja oziroma ali gre za območje ZP z drugačnim osnovnim namenom, ki pa je po svojih značilnostih primerno tudi za TD. Pri tem so kot izhodišče opredeljene tri kategorije namenskosti ZP: večnamenska, eneonamenska in nenamenska. 

Slika 3: Možni pristopi določanja in vrednotenja eno- in večnamenskih ZP za prostorsko zgoščene TD.
 ![postopek določitve zelenih površin za telesno dejavnost](slika3.png)

**2.	Kazalnik PREZENCA za zelene površine za daljinske oblike telesne dejavnosti**  
Kazalnik PREZENCA za določitev ZP za daljinske oblike TD opredeljuje tri obvezne atribute: ureditev za hojo in kolesarjenje, potek po območjih z značilnostmi ZP in ustrezna dolžina poti. Za vrednotenje vidikov kakovosti in klasifikacije v razrede kakovosti je obvezni atribut za upoštevanje ZP pri oceni preskrbljenosti varnost, opremljenost, ambientalna privlačnost in univerzalno oblikovanje, za katero pa enkrat še ni sistemskega zbiranja relevantnih podatkov.   

Slika 4: Vidiki za določitev in vrednotenje kakovosti ZP za daljinske oblike telesne dejavnosti.
![postopek določitve zelenih površin za telesno dejavnost](slika4.png)
  
***Določitev ZP za daljinske oblike TD***  
ZP za daljinske oblike TD smo določili preko kombinacije podatkov OpenStreetMap in gospodarske javne infrastrukture (GURS, 2024), pri čemer smo uporabili različne filtre slojev.

***Dostopnost do ZP za daljinske oblike TD***  
Oddaljenost je bila računana med stanovanjskimi stavbami na testnem območju in ZP za daljinske oblike TD. Stavba ima dostop do določenega tipa ZP za daljinske oblike TD v kolikor se v 50 m območju okoli nje nahaja tovrsten tip ZP za daljinske oblike TD.

***Vrednotenje ZP za daljinske oblike TD***  
Vrednotenje se zaradi kompleksnosti vidikov ni izvedlo.

## Digitalni podatki
V prilogi so prostorski podatki zbrani ločeno za vsako testno območje v obliki:
- Geopackage format (prezenca_obcina_celje.gpkg in prezenca_obcina_miklavz.gpkg)
- QGIS projekt (qgis_prezenca_obcina_celje.qgz  in qgis_prezenca_obcina_miklavz.qgz  )
- Interpretacijski ključ slojev (interpretacijski_kljuc_prezenca.xlsx)

Preglednica 1: sloji v geopackage datotekah
| Ime sloja                  | Opis sloja                                                                                                                                                                                                                                                                            | Datum zadnje posodobitve   |
|:---------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:---------------------------|
| zp_za_zgoscene_td          | zelene površine za zgoščene oblike telesnih dejavnosti                                                                                                                                                                                                                                | maj 2024                   |
| dostopnost_zgoscene        | Dostopnost do ZP za zgoščene oblike TD. Točkovni sloj po hišnih naslovih, združen z bližnjimi zelenimi površinami. Posamezen naslov se zato lahko pojavi večkrat. Iz teh podatkov se lahko izdela poljubne poizvedbe – npr. razdalja do najbližje zelene površine določene velikosti. | maj 2024                   |
| testno_obmocje_zgoscene    | razdalja 900 m od stanovanjskih stavb mestnih četrti (Celje) oz. krajevnih skupnosti (Miklavž na Dravskem polju)                                                                                                                                                                      | december 2023              |
| zp_za_daljinske_td         | zelene površine za daljinske oblike telesne dejavnosti                                                                                                                                                                                                                                | maj 2024                   |
| dostopnost_daljinske       | dostopnost do ZP za daljinske oblike TD                                                                                                                                                                                                                                               | maj 2024                   |
| testno_obmocje_daljinske   | razdalja 6 km od stanovanjskih stavb mestnih četrti (Celje) oz. krajevnih skupnosti (Miklavž)                                                                                                                                                                                         | december 2023              |
| mestne_cetrti_celje        | mestne četrti mestne občine Celje                                                                                                                                                                                                                                                     | maj 2024                   |
| krajevne_skupnosti_miklavz | krajevne skupnosti občine Miklavž na Dravskem polju                                                                                                                                                                                                                                   | maj 2024                   |
| oprema_igra                | Oprema za igro (npr. otroška igrala)                                                                                                                                                                                                                                                  | maj 2024                   |
| oprema_sport               | Oprema za šport (npr. igrišče za nogomet, košarko, itd.)                                                                                                                                                                                                                              | maj 2024                   |
| oprema_splosno             | Splošna oprema (npr. klopi, pitniki, itd.)                                                                                                                                                                                                                                            | maj 2024                   |
| zp_za_td_sifrant           | Šifrant za relacijo s slojem zp_za_zgoscene_td                                                                                                                                                                                                                                        | maj 2024                   |

**Digitalni podatki**

V prilogi so prostorski podatki zbrani ločeno za vsako testno območje v obliki:

*   Geopackage format (prezenca\_obcina\_celje.gpkg in prezenca\_obcina\_miklavz.gpkg)
*   QGIS projekt (qgis\_prezenca\_obcina\_celje.qgz in qgis\_prezenca\_obcina\_miklavz.qgz )
*   Interpretacijski ključ slojev (interpretacijski\_kljuc\_prezenca.xlsx)

Preglednica: sloji v geopackage datotekah

| Ime sloja | Opis sloja | Datum zadnje posodobitve |
| --- | --- | --- |
| zp_za_zgoscene_td | zelene površine za zgoščene oblike telesnih dejavnosti | maj 2024 |
| dostopnost_zgoscene | Dostopnost do ZP za zgoščene oblike TD. Točkovni sloj po hišnih naslovih, združen z bližnjimi zelenimi površinami. Posamezen naslov se zato lahko pojavi večkrat. Iz teh podatkov se lahko izdela poljubne poizvedbe – npr. razdalja do najbližje zelene površine določene velikosti. | maj 2024 |
| testno_obmocje_zgoscene | razdalja 900 m od stanovanjskih stavb mestnih četrti (Celje) oz. krajevnih skupnosti (Miklavž na Dravskem polju) | december 2023 |
| zp_za_daljinske_td | zelene površine za daljinske oblike telesne dejavnosti | maj 2024 |
| dostopnost_daljinske | dostopnost do ZP za daljinske oblike TD | maj 2024 |
| testno_obmocje_daljinske | razdalja 6 km od stanovanjskih stavb mestnih četrti (Celje) oz. krajevnih skupnosti (Miklavž) | december 2023 |
| mestne_cetrti_celje | mestne četrti mestne občine Celje | maj 2024 |
| krajevne_skupnosti_miklavz | krajevne skupnosti občine Miklavž na Dravskem polju | maj 2024 |
| oprema_igra | Oprema za igro (npr. otroška igrala) | maj 2024 |
| oprema_sport | Oprema za šport (npr. igrišče za nogomet, košarko, itd.) | maj 2024 |
| oprema_splosno | Splošna oprema (npr. klopi, pitniki, itd.) | maj 2024 |
| zp_za_td_sifrant | Šifrant za relacijo s slojem zp_za_zgoscene_td | maj 2024 |

## atributivni podatki
| sloj                     |   vrstni red | ime stolpca              | podatkovni tip   | opis                                                                                                                                                                                                                        |
|:-------------------------|-------------:|:-------------------------|:--------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| zp_za_zgoscene_td        |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| zp_za_zgoscene_td        |            2 | gid                      | integer       | primarni ključ za relacijo s tabelami za opremo                                                                                                                                                                             |
| zp_za_zgoscene_td        |            3 | tipologija               | text          | tiplogija zelene površine za telesno dejavnost                                                                                                                                                                              |
| zp_za_zgoscene_td        |            4 | tipologija_drugo         | text          | tiplogija zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                            |
| zp_za_zgoscene_td        |            5 | tipologija_opomba        | text          | tiplogija zelene površine za telesno dejavnost - opombe                                                                                                                                                                     |
| zp_za_zgoscene_td        |            6 | dostop                   | text          | tip dostopnosti do zelene površine za telesno dejavnost                                                                                                                                                                     |
| zp_za_zgoscene_td        |            7 | dostop_drugo             | text          | tip dostopnosti do zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                   |
| zp_za_zgoscene_td        |            8 | dostop_opomba            | text          | tip dostopnosti do zelene površine za telesno dejavnost - opombe                                                                                                                                                            |
| zp_za_zgoscene_td        |            9 | ambient                  | text          | tip ambientalne privlačnosti do zelene površine za telesno dejavnost                                                                                                                                                        |
| zp_za_zgoscene_td        |           10 | ambient_drugo            | text          | tip ambientalne privlačnosti do zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                      |
| zp_za_zgoscene_td        |           11 | ambient_opomba           | text          | tip ambientalne privlačnosti do zelene površine za telesno dejavnost - opombe                                                                                                                                               |
| zp_za_zgoscene_td        |           12 | vzdrzevanost             | text          | tip vzdrževanosti zelene površine za telesno dejavnost                                                                                                                                                                      |
| zp_za_zgoscene_td        |           13 | vzdrzevanost_drugo       | text          | tip vzdrževanosti zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                    |
| zp_za_zgoscene_td        |           14 | vzdrzevanost_opomba      | text          | tip vzdrževanosti zelene površine za telesno dejavnost - opombe                                                                                                                                                             |
| zp_za_zgoscene_td        |           15 | varnost                  | text          | tip varnosti zelene površine za telesno dejavnost                                                                                                                                                                           |
| zp_za_zgoscene_td        |           16 | varnost_drugo            | text          | tip varnosti zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                         |
| zp_za_zgoscene_td        |           17 | varnost_opomba           | text          | tip varnosti zelene površine za telesno dejavnost - opombe                                                                                                                                                                  |
| zp_za_zgoscene_td        |           18 | vir_podatka              | text          | vir originalnega podatka zelene površine za telesno dejavnost                                                                                                                                                               |
| zp_za_zgoscene_td        |           19 | pozidanost_mean          | numeric       | delež prepustnosti tal zelene površine za telesno dejavnost                                                                                                                                                                 |
| zp_za_zgoscene_td        |           20 | area                     | integer       | površina ZP za TD                                                                                                                                                                                                           |
| dostopnost_zgoscene      |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| dostopnost_zgoscene      |            2 | zp_gid                   | integer       | številčenje zelene površine                                                                                                                                                                                                 |
| dostopnost_zgoscene      |            3 | eid_hisna_stevilka       | integer       | oštevilčenje hišnih številk GURS                                                                                                                                                                                            |
| dostopnost_zgoscene      |            4 | namenskost               | text          | enonamenska/večnamenska raba razporejeno glede na tipologijo                                                                                                                                                                |
| dostopnost_zgoscene      |            5 | povrsina                 | integer       | površina zelene površine za telesno dejavnost                                                                                                                                                                               |
| dostopnost_zgoscene      |            6 | total_duration           | numeric       | časovna razdalja za hojo od hišnega naslova do zelene površine v minutah                                                                                                                                                    |
| dostopnost_zgoscene      |            7 | obcina_sifra             | integer       | šifra občine                                                                                                                                                                                                                |
| dostopnost_zgoscene      |            8 | tot_p                    | numeric       | število prebivalcev na hišni naslov - demografski podatki v okviru prostorske enote 100 x 100 m (SURS, 2024) pripisani na hišne naslove                                                                                     |
| dostopnost_zgoscene      |            9 | p_00_14                  | numeric       | število prebivalcev  v starostni skupini 0 - 14 let na hišni naslov  - demografski podatki v okviru prostorske enote 100 x 100 m (SURS, 2024) pripisani na hišne naslove                                                    |
| dostopnost_zgoscene      |           10 | p_15_64                  | numeric       | število prebivalcev  v starostni skupini 15 - 64 let na hišni naslov - demografski podatki v okviru prostorske enote 100 x 100 m (SURS, 2024) pripisani na hišne naslove                                                    |
| dostopnost_zgoscene      |           11 | p_65_                    | numeric       | število prebivalcev  v starostni skupini nad 65 let na hišni naslov - demografski podatki v okviru prostorske enote 100 x 100 m (SURS, 2024) pripisani na hišne naslove                                                     |
| dostopnost_zgoscene      |           12 | tipologija               | text          | tiplogija zelene površine za telesno dejavnost                                                                                                                                                                              |
| dostopnost_zgoscene      |           13 | tipologija_drugo         | text          | tiplogija zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                            |
| dostopnost_zgoscene      |           14 | tipologija_opomba        | text          | tiplogija zelene površine za telesno dejavnost - opombe                                                                                                                                                                     |
| dostopnost_zgoscene      |           15 | dostop                   | text          | tip dostopnosti do zelene površine za telesno dejavnost                                                                                                                                                                     |
| dostopnost_zgoscene      |           16 | dostop_drugo             | text          | tip dostopnosti do zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                   |
| dostopnost_zgoscene      |           17 | dostop_opomba            | text          | tip dostopnosti do zelene površine za telesno dejavnost - opombe                                                                                                                                                            |
| dostopnost_zgoscene      |           18 | ambient                  | text          | tip ambientalne privlačnosti do zelene površine za telesno dejavnost                                                                                                                                                        |
| dostopnost_zgoscene      |           19 | ambient_drugo            | text          | tip ambientalne privlačnosti do zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                      |
| dostopnost_zgoscene      |           20 | ambient_opomba           | text          | tip ambientalne privlačnosti do zelene površine za telesno dejavnost - opombe                                                                                                                                               |
| dostopnost_zgoscene      |           21 | vzdrzevanost             | text          | tip vzdrževanosti zelene površine za telesno dejavnost                                                                                                                                                                      |
| dostopnost_zgoscene      |           22 | vzdrzevanost_drugo       | text          | tip vzdrževanosti zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                    |
| dostopnost_zgoscene      |           23 | vzdrzevanost_opomba      | text          | tip vzdrževanosti zelene površine za telesno dejavnost - opombe                                                                                                                                                             |
| dostopnost_zgoscene      |           24 | varnost                  | text          | tip varnosti zelene površine za telesno dejavnost                                                                                                                                                                           |
| dostopnost_zgoscene      |           25 | varnost_drugo            | text          | tip varnosti zelene površine za telesno dejavnost - druga tiplogija                                                                                                                                                         |
| dostopnost_zgoscene      |           26 | varnost_opomba           | text          | tip varnosti zelene površine za telesno dejavnost - opombe                                                                                                                                                                  |
| dostopnost_zgoscene      |           27 | vir_podatka              | text          | vir originalnega podatka  zelene površine za telesno dejavnost (osm: OpenStreetMap; esz: Evidenca stavbnih zemljišč; MKGP - kmetijstvo in gozd: gozd in kmetijske površine iz dejasnke rabe kmetijskih in gozdnih zemljišč) |
| dostopnost_zgoscene      |           28 | pozidanost_mean          | numeric       | delež prepustnosti tal zelene površine za telesno dejavnost                                                                                                                                                                 |
| testno_obmocje_zgoscene  |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| zp_za_daljinske_td       |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| zp_za_daljinske_td       |            2 | lenght                   | integer       | dolžina poti v metrih                                                                                                                                                                                                       |
| zp_za_daljinske_td       |            3 | layer                    | text          | opredelitev tipa ZP za daljinske oblike TD                                                                                                                                                                                  |
| dostopnost_daljinske     |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| dostopnost_daljinske     |            2 | eid_stavba               | integer       | enolični identifikator stavbe znotraj katastra                                                                                                                                                                              |
| dostopnost_daljinske     |            3 | prev_raba_id             | integer       | id rabe dela stavb, ki se znotraj stavbe najpogosteje pojavi                                                                                                                                                                |
| dostopnost_daljinske     |            4 | prev_raba_opis           | text          | opis rabe dela stavb, ki se znotraj stavbe najpogosteje pojavi                                                                                                                                                              |
| dostopnost_daljinske     |            5 | stevilo_dst              | integer       | število vseh delov stavb znotraj stavbe                                                                                                                                                                                     |
| dostopnost_daljinske     |            6 | stevilo_dst_prev_raba    | integer       | število delov stavb prevladujoče rabe znotraj stavbe                                                                                                                                                                        |
| dostopnost_daljinske     |            7 | povrsina_stavbe          | numeric       | seštevek površine vseh delov stavbe                                                                                                                                                                                         |
| dostopnost_daljinske     |            8 | povrsina_dst_prev_raba   | numeric       | skupna površina delov stavbe prevladujoče rabe                                                                                                                                                                              |
| dostopnost_daljinske     |            9 | delez_dst_prev_raba      | numeric       | delež skupne površine delov stavbe                                                                                                                                                                                          |
| dostopnost_daljinske     |           10 | vse_rabe                 | text          | vse rabe delov stavb s pripadajočim številom in deležem površine                                                                                                                                                            |
| dostopnost_daljinske     |           11 | dostop_pesci             | integer       | Dostopnost stanovanjskih objektov do poti primernih za pešce (1= dostopno, 0= brez dostopa)                                                                                                                                 |
| dostopnost_daljinske     |           12 | dostop_pesci_zp          | integer       | Dostopnost stanovanjskih objektov do poti primernih za pešce, ki potekajo po območjih z značilnostmi ZP (1= dostopno, 0= brez dostopa)                                                                                      |
| dostopnost_daljinske     |           13 | dostop_kolo              | integer       | Dostopnost stanovanjskih objektov do poti primernih za kolesarje (1= dostopno, 0= brez dostopa)                                                                                                                             |
| dostopnost_daljinske     |           14 | dostop_kolo_zp           | integer       | Dostopnost stanovanjskih objektov do poti primernih za kolesarje, ki potekajo po območjih z značilnostmi ZP (1= dostopno, 0= brez dostopa)                                                                                  |
| dostopnost_daljinske     |           15 | dostop_mesana_raba       | integer       | Dostopnost stanovanjskih objektov do poti za mešan promet (1= dostopno, 0= brez dostopa)                                                                                                                                    |
| dostopnost_daljinske     |           16 | dostop_mesana_zp         | integer       | Dostopnost stanovanjskih objektov do poti za mešan promet, ki potekajo po območjih z značilnostmi ZP (1= dostopno, 0= brez dostopa)                                                                                         |
| dostopnost_daljinske     |           17 | dostop_vse_tri           | integer       | Dostopnost stanovanjskih objektov do vseh poti (1= dostopno, 0= brez dostopa)                                                                                                                                               |
| dostopnost_daljinske     |           18 | dostop_vse_tri_zp        | integer       | Dostopnost stanovanjskih objektov do vseh poti, ki potekajo po območjih z značilnostmi ZP (1= dostopno, 0= brez dostopa)                                                                                                    |
| dostopnost_daljinske     |           19 | dostop_vse_stevilo       | integer       | Seštevek do koliko tipov poti (max. 3) ima stanovanjska stavba dostop                                                                                                                                                       |
| testno_obmocje_daljinske |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| mestne_cetrti_celje      |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| mestne_cetrti_celje      |            2 | sifra                    | integer       | šifra krajevne skupnosti                                                                                                                                                                                                    |
| mestne_cetrti_celje      |            3 | naziv                    | text          | ime krajevne skupnosti                                                                                                                                                                                                      |
| mestne_cetrti_celje      |            4 | obcina_sifra             | integer       | šifra občine                                                                                                                                                                                                                |
| mestne_cetrti_celje      |            5 | statisticna_regija_sifra | integer       | šifra statistične regije                                                                                                                                                                                                    |
| oprema_igra              |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| oprema_igra              |            2 | zp_za_td_gid             | integer       | povezava na sloj zp_za_zgoscene_td; v kolikor je polje prazno, pomeni da ta kos opreme ne pripada nobenemu poligonu                                                                                                         |
| oprema_igra              |            3 | kategorija               | text          | kategorija opreme (igra, šport ali splošna oprema)                                                                                                                                                                          |
| oprema_igra              |            4 | tip                      | text          | tip opreme - podkategorija kategorije                                                                                                                                                                                       |
| oprema_igra              |            5 | stevilo                  | integer       | število opreme na ZP ta TD                                                                                                                                                                                                  |
| oprema_sport             |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| oprema_sport             |            2 | zp_za_td_gid             | integer       | povezava na sloj zp_za_zgoscene_td                                                                                                                                                                                          |
| oprema_sport             |            3 | kategorija               | text          | kategorija opreme (igra, šport ali splošna oprema)                                                                                                                                                                          |
| oprema_sport             |            4 | tip                      | text          | tip opreme - podkategorija kategorije                                                                                                                                                                                       |
| oprema_sport             |            5 | stevilo                  | integer       | število kosov opreme                                                                                                                                                                                                        |
| oprema_splosno           |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| oprema_splosno           |            2 | zp_za_td_gid             | integer       | povezava na sloj zp_za_zgoscene_td; v kolikor je polje prazno, pomeni da ta kos opreme ne pripada nobenemu poligonu                                                                                                         |
| oprema_splosno           |            3 | kategorija               | text          | kategorija opreme (igra, šport ali splošna oprema)                                                                                                                                                                          |
| oprema_splosno           |            4 | tip                      | text          | tip opreme                                                                                                                                                                                                                  |
| oprema_splosno           |            5 | stevilo                  | integer       | število kosov opreme                                                                                                                                                                                                        |
| zp_za_td_sifrant         |            1 | fid                      | integer       | primarni ključ                                                                                                                                                                                                              |
| zp_za_td_sifrant         |            2 | gid                      | integer       | enolični identifikator                                                                                                                                                                                                      |
| zp_za_td_sifrant         |            3 | stolpec                  | text          | ime stolpca za relacijo s slojem zp_za_zgoscene_td                                                                                                                                                                          |
| zp_za_td_sifrant         |            4 | sort                     | integer       | vrstni red stolpcev                                                                                                                                                                                                         |
| zp_za_td_sifrant         |            5 | atribut                  | text          | opis atributa                                                                                                                                                                                                               |

## Več informacij o projektu
Več o projektu na spletni strani: http://prezenca.uirs.si/sl-si/

Natančnejša predstavitev določitve in izračuna dostopnosti je v poročilih projekta PREZENCA: 
- Žlender, V., Šuklje Erjavec, I., Kozamernik, J., Koblar, S., & Brišnik, R. (2024). Priprava kazalnikov za oceno preskrbljenosti naselij z zelenimi površinami za telesno dejavnost v odprtem prostoru (PREZENCA): ciljno raziskovalni projekt (CRP)- 2024: št. projekta V5-2232: končno poročilo projekta, 51 str. Urbanistični inštitut Republike Slovenije.
- Kozamernik, J., Šuklje Erjavec, I., Koblar, S., Brišnik, R., & Žlender, V. (2024). Razvoj koncepta za opredelitev območij zelenih površin za prostorsko zgoščene oblike telesnih dejavnosti = Developing a concept to define green spaces suitable for spatially concentrated forms of physical activity. Urbani izziv, 35(2), 17-32,. https://www.urbaniizziv.si/Portals/urbaniizziv/Clanki/2024/urbani-izziv-2024-35-02-02.pdf
- Žlender, V., Šuklje Erjavec, I., Kozamernik, J., Koblar, S., & Brišnik, R. (2024). Poročilo o pilotnih projektih: Miklavž na Dravskem polju: priprava kazalnikov za oceno preskrbljenosti naselji z zelenimi površinami za telesno dejavnost v odprtem prostoru (PREZENCA): ciljno raziskovalni projekt (CRP) V5-2232,  83 str. Urbanistični inštitut Republike Slovenije.
- Žlender, V., Šuklje Erjavec, I., Kozamernik, J., Koblar, S., & Brišnik, R. (2024). Poročilo o pilotnih projektih: Mestna občina Celje: priprava kazalnikov za oceno preskrbljenosti naselji z zelenimi površinami za telesno dejavnost v odprtem prostoru (PREZENCA): ciljno raziskovalni projekt (CRP) V5-2232, 80 str. Urbanistični inštitut Republike Slovenije.
- Žlender, V., Šuklje Erjavec, I., Kozamernik, J., Koblar, S., & Brišnik, R. (2023). Priprava kazalnikov za oceno preskrbljenosti naselij z zelenimi površinami za telesno dejavnost v odprtem prostoru (PREZENCA): ciljno raziskovalni projekt (CRP)- 2023: št. projekta V5-2232: vmesno poročilo o opravljenem delu, 96 str. Urbanistični inštitut Republike Slovenije.
- Žlender, V., Šuklje Erjavec, I., Kozamernik, J., & Koblar, S. (2022). Priprava kazalnikov za oceno preskrbljenosti naselij z zelenimi površinami za telesno dejavnost v odprtem prostoru (PREZENCA): ciljno raziskovalni projekt (CRP)- 2022: št. projekta V5-2232: prvo poročilo o opravljenem delu, 14 str. Urbanistični inštitut Republike Slovenije.